/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.util.Log;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CombinedData
extends BarLineScatterCandleBubbleData<IBarLineScatterCandleBubbleDataSet<? extends Entry>> {
    private LineData mLineData;
    private BarData mBarData;
    private ScatterData mScatterData;
    private CandleData mCandleData;
    private BubbleData mBubbleData;

    public void setData(LineData data) {
        this.mLineData = data;
        this.notifyDataChanged();
    }

    public void setData(BarData data) {
        this.mBarData = data;
        this.notifyDataChanged();
    }

    public void setData(ScatterData data) {
        this.mScatterData = data;
        this.notifyDataChanged();
    }

    public void setData(CandleData data) {
        this.mCandleData = data;
        this.notifyDataChanged();
    }

    public void setData(BubbleData data) {
        this.mBubbleData = data;
        this.notifyDataChanged();
    }

    @Override
    public void calcMinMax() {
        if (this.mDataSets == null) {
            this.mDataSets = new ArrayList();
        }
        this.mDataSets.clear();
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        List<BarLineScatterCandleBubbleData> allData = this.getAllData();
        for (ChartData chartData : allData) {
            chartData.calcMinMax();
            List sets = chartData.getDataSets();
            this.mDataSets.addAll(sets);
            if (chartData.getYMax() > this.mYMax) {
                this.mYMax = chartData.getYMax();
            }
            if (chartData.getYMin() < this.mYMin) {
                this.mYMin = chartData.getYMin();
            }
            if (chartData.getXMax() > this.mXMax) {
                this.mXMax = chartData.getXMax();
            }
            if (chartData.getXMin() < this.mXMin) {
                this.mXMin = chartData.getXMin();
            }
            if (chartData.mLeftAxisMax > this.mLeftAxisMax) {
                this.mLeftAxisMax = chartData.mLeftAxisMax;
            }
            if (chartData.mLeftAxisMin < this.mLeftAxisMin) {
                this.mLeftAxisMin = chartData.mLeftAxisMin;
            }
            if (chartData.mRightAxisMax > this.mRightAxisMax) {
                this.mRightAxisMax = chartData.mRightAxisMax;
            }
            if (!(chartData.mRightAxisMin < this.mRightAxisMin)) continue;
            this.mRightAxisMin = chartData.mRightAxisMin;
        }
    }

    public BubbleData getBubbleData() {
        return this.mBubbleData;
    }

    public LineData getLineData() {
        return this.mLineData;
    }

    public BarData getBarData() {
        return this.mBarData;
    }

    public ScatterData getScatterData() {
        return this.mScatterData;
    }

    public CandleData getCandleData() {
        return this.mCandleData;
    }

    public List<BarLineScatterCandleBubbleData> getAllData() {
        ArrayList<BarLineScatterCandleBubbleData> data = new ArrayList<BarLineScatterCandleBubbleData>();
        if (this.mLineData != null) {
            data.add(this.mLineData);
        }
        if (this.mBarData != null) {
            data.add(this.mBarData);
        }
        if (this.mScatterData != null) {
            data.add(this.mScatterData);
        }
        if (this.mCandleData != null) {
            data.add(this.mCandleData);
        }
        if (this.mBubbleData != null) {
            data.add(this.mBubbleData);
        }
        return data;
    }

    public BarLineScatterCandleBubbleData getDataByIndex(int index) {
        return this.getAllData().get(index);
    }

    @Override
    public void notifyDataChanged() {
        if (this.mLineData != null) {
            this.mLineData.notifyDataChanged();
        }
        if (this.mBarData != null) {
            this.mBarData.notifyDataChanged();
        }
        if (this.mCandleData != null) {
            this.mCandleData.notifyDataChanged();
        }
        if (this.mScatterData != null) {
            this.mScatterData.notifyDataChanged();
        }
        if (this.mBubbleData != null) {
            this.mBubbleData.notifyDataChanged();
        }
        this.calcMinMax();
    }

    @Override
    public Entry getEntryForHighlight(Highlight highlight) {
        if (highlight.getDataIndex() >= this.getAllData().size()) {
            return null;
        }
        BarLineScatterCandleBubbleData data = this.getDataByIndex(highlight.getDataIndex());
        if (highlight.getDataSetIndex() >= data.getDataSetCount()) {
            return null;
        }
        List entries = data.getDataSetByIndex(highlight.getDataSetIndex()).getEntriesForXValue(highlight.getX());
        for (Entry entry : entries) {
            if (entry.getY() != highlight.getY() && !Float.isNaN(highlight.getY())) continue;
            return entry;
        }
        return null;
    }

    public IBarLineScatterCandleBubbleDataSet<? extends Entry> getDataSetByHighlight(Highlight highlight) {
        if (highlight.getDataIndex() >= this.getAllData().size()) {
            return null;
        }
        BarLineScatterCandleBubbleData data = this.getDataByIndex(highlight.getDataIndex());
        if (highlight.getDataSetIndex() >= data.getDataSetCount()) {
            return null;
        }
        return (IBarLineScatterCandleBubbleDataSet)data.getDataSets().get(highlight.getDataSetIndex());
    }

    public int getDataIndex(ChartData data) {
        return this.getAllData().indexOf(data);
    }

    @Override
    public boolean removeDataSet(IBarLineScatterCandleBubbleDataSet<? extends Entry> d) {
        ChartData data;
        List<BarLineScatterCandleBubbleData> datas = this.getAllData();
        boolean success = false;
        Iterator<BarLineScatterCandleBubbleData> iterator = datas.iterator();
        while (iterator.hasNext() && !(success = (data = (ChartData)iterator.next()).removeDataSet(d))) {
        }
        return success;
    }

    @Override
    @Deprecated
    public boolean removeDataSet(int index) {
        Log.e((String)"MPAndroidChart", (String)"removeDataSet(int index) not supported for CombinedData");
        return false;
    }

    @Override
    @Deprecated
    public boolean removeEntry(Entry e, int dataSetIndex) {
        Log.e((String)"MPAndroidChart", (String)"removeEntry(...) not supported for CombinedData");
        return false;
    }

    @Override
    @Deprecated
    public boolean removeEntry(float xValue, int dataSetIndex) {
        Log.e((String)"MPAndroidChart", (String)"removeEntry(...) not supported for CombinedData");
        return false;
    }
}

