/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import java.io.File;

public class AgentWebConfig {
    static final String FILE_CACHE_PATH = "agentweb-cache";
    static final String AGENTWEB_CACHE_PATCH = File.separator + "agentweb-cache";
    static String AGENTWEB_FILE_PATH;
    public static boolean DEBUG;
    static final boolean IS_KITKAT_OR_BELOW_KITKAT;
    public static final int WEBVIEW_DEFAULT_TYPE = 1;
    public static final int WEBVIEW_AGENTWEB_SAFE_TYPE = 2;
    public static final int WEBVIEW_CUSTOM_TYPE = 3;
    static int WEBVIEW_TYPE;
    private static volatile boolean IS_INITIALIZED;
    private static final String TAG;
    public static final String AGENTWEB_VERSION = " agentweb/4.0.2 ";
    public static final String AGENTWEB_NAME = "AgentWeb";
    public static int MAX_FILE_LENGTH;

    public static String getCookiesByUrl(String url) {
        return CookieManager.getInstance() == null ? null : CookieManager.getInstance().getCookie(url);
    }

    public static void debug() {
        DEBUG = true;
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    public static void removeExpiredCookies() {
        CookieManager mCookieManager = null;
        mCookieManager = CookieManager.getInstance();
        if (mCookieManager != null) {
            mCookieManager.removeExpiredCookie();
            AgentWebConfig.toSyncCookies();
        }
    }

    public static void removeAllCookies() {
        AgentWebConfig.removeAllCookies(null);
    }

    public static void removeSessionCookies() {
        AgentWebConfig.removeSessionCookies(null);
    }

    public static void syncCookie(String url, String cookies) {
        CookieManager mCookieManager = CookieManager.getInstance();
        if (mCookieManager != null) {
            mCookieManager.setCookie(url, cookies);
            AgentWebConfig.toSyncCookies();
        }
    }

    public static void removeSessionCookies(ValueCallback<Boolean> callback) {
        if (callback == null) {
            callback = AgentWebConfig.getDefaultIgnoreCallback();
        }
        if (CookieManager.getInstance() == null) {
            callback.onReceiveValue((Object)new Boolean(false));
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            CookieManager.getInstance().removeSessionCookie();
            AgentWebConfig.toSyncCookies();
            callback.onReceiveValue((Object)new Boolean(true));
            return;
        }
        CookieManager.getInstance().removeSessionCookies(callback);
        AgentWebConfig.toSyncCookies();
    }

    public static String getCachePath(Context context) {
        return context.getCacheDir().getAbsolutePath() + AGENTWEB_CACHE_PATCH;
    }

    public static String getExternalCachePath(Context context) {
        return AgentWebUtils.getAgentWebFilePath(context);
    }

    public static void removeAllCookies(@Nullable ValueCallback<Boolean> callback) {
        if (callback == null) {
            callback = AgentWebConfig.getDefaultIgnoreCallback();
        }
        if (Build.VERSION.SDK_INT < 21) {
            CookieManager.getInstance().removeAllCookie();
            AgentWebConfig.toSyncCookies();
            callback.onReceiveValue((Object)(!CookieManager.getInstance().hasCookies() ? 1 : 0));
            return;
        }
        CookieManager.getInstance().removeAllCookies(callback);
        AgentWebConfig.toSyncCookies();
    }

    public static synchronized void clearDiskCache(Context context) {
        block3: {
            try {
                AgentWebUtils.clearCacheFolder(new File(AgentWebConfig.getCachePath(context)), 0);
                String path = AgentWebConfig.getExternalCachePath(context);
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    File mFile = new File(path);
                    AgentWebUtils.clearCacheFolder(mFile, 0);
                }
            }
            catch (Throwable throwable) {
                if (!LogUtils.isDebug()) break block3;
                throwable.printStackTrace();
            }
        }
    }

    static synchronized void initCookiesManager(Context context) {
        if (!IS_INITIALIZED) {
            AgentWebConfig.createCookiesSyncInstance(context);
            IS_INITIALIZED = true;
        }
    }

    private static void createCookiesSyncInstance(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.createInstance((Context)context);
        }
    }

    private static void toSyncCookies() {
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.getInstance().sync();
            return;
        }
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                CookieManager.getInstance().flush();
            }
        });
    }

    static String getDatabasesCachePath(Context context) {
        return context.getApplicationContext().getDir("database", 0).getPath();
    }

    private static ValueCallback<Boolean> getDefaultIgnoreCallback() {
        return new ValueCallback<Boolean>(){

            public void onReceiveValue(Boolean ignore) {
                LogUtils.i(TAG, "removeExpiredCookies:" + ignore);
            }
        };
    }

    static {
        DEBUG = false;
        IS_KITKAT_OR_BELOW_KITKAT = Build.VERSION.SDK_INT <= 19;
        WEBVIEW_TYPE = 1;
        IS_INITIALIZED = false;
        TAG = AgentWebConfig.class.getSimpleName();
        MAX_FILE_LENGTH = 0x500000;
    }
}

