/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebView;
import android.widget.EditText;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.R;
import com.just.agentweb.WebParentLayout;

public class DefaultUIController
extends AbsAgentWebUIController {
    private AlertDialog mAlertDialog;
    protected AlertDialog mConfirmDialog;
    private JsPromptResult mJsPromptResult = null;
    private JsResult mJsResult = null;
    private AlertDialog mPromptDialog = null;
    private Activity mActivity;
    private WebParentLayout mWebParentLayout;
    private AlertDialog mAskOpenOtherAppDialog = null;
    private ProgressDialog mProgressDialog;
    private Resources mResources = null;

    @Override
    public void onJsAlert(WebView view, String url, String message) {
        AgentWebUtils.toastShowShort(view.getContext().getApplicationContext(), message);
    }

    @Override
    public void onOpenPagePrompt(WebView view, String url, final Handler.Callback callback) {
        LogUtils.i(this.TAG, "onOpenPagePrompt");
        if (this.mAskOpenOtherAppDialog == null) {
            this.mAskOpenOtherAppDialog = new AlertDialog.Builder((Context)this.mActivity).setMessage((CharSequence)this.mResources.getString(R.string.agentweb_leave_app_and_go_other_page, new Object[]{AgentWebUtils.getApplicationName((Context)this.mActivity)})).setTitle((CharSequence)this.mResources.getString(R.string.agentweb_tips)).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.handleMessage(Message.obtain(null, (int)-1));
                    }
                }
            }).setPositiveButton((CharSequence)this.mResources.getString(R.string.agentweb_leave), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (callback != null) {
                        callback.handleMessage(Message.obtain(null, (int)1));
                    }
                }
            }).create();
        }
        this.mAskOpenOtherAppDialog.show();
    }

    @Override
    public void onJsConfirm(WebView view, String url, String message, JsResult jsResult) {
        this.onJsConfirmInternal(message, jsResult);
    }

    @Override
    public void onSelectItemsPrompt(WebView view, String url, String[] ways, Handler.Callback callback) {
        this.showChooserInternal(ways, callback);
    }

    @Override
    public void onForceDownloadAlert(String url, Handler.Callback callback) {
        this.onForceDownloadAlertInternal(callback);
    }

    private void onForceDownloadAlertInternal(final Handler.Callback callback) {
        Activity mActivity = this.mActivity;
        if (mActivity == null || mActivity.isFinishing()) {
            return;
        }
        AlertDialog mAlertDialog = null;
        mAlertDialog = new AlertDialog.Builder((Context)mActivity).setTitle((CharSequence)this.mResources.getString(R.string.agentweb_tips)).setMessage((CharSequence)this.mResources.getString(R.string.agentweb_honeycomblow)).setNegativeButton((CharSequence)this.mResources.getString(R.string.agentweb_download), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (dialog != null) {
                    dialog.dismiss();
                }
                if (callback != null) {
                    callback.handleMessage(Message.obtain());
                }
            }
        }).setPositiveButton((CharSequence)this.mResources.getString(R.string.agentweb_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (dialog != null) {
                    dialog.dismiss();
                }
            }
        }).create();
        mAlertDialog.show();
    }

    private void showChooserInternal(String[] ways, final Handler.Callback callback) {
        this.mAlertDialog = new AlertDialog.Builder((Context)this.mActivity).setSingleChoiceItems((CharSequence[])ways, -1, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                LogUtils.i(DefaultUIController.this.TAG, "which:" + which);
                if (callback != null) {
                    Message mMessage = Message.obtain();
                    mMessage.what = which;
                    callback.handleMessage(mMessage);
                }
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
                if (callback != null) {
                    callback.handleMessage(Message.obtain(null, (int)-1));
                }
            }
        }).create();
        this.mAlertDialog.show();
    }

    private void onJsConfirmInternal(String message, JsResult jsResult) {
        LogUtils.i(this.TAG, "activity:" + this.mActivity.hashCode() + "  ");
        Activity mActivity = this.mActivity;
        if (mActivity == null || mActivity.isFinishing()) {
            this.toCancelJsresult(jsResult);
            return;
        }
        if (this.mConfirmDialog == null) {
            this.mConfirmDialog = new AlertDialog.Builder((Context)mActivity).setMessage((CharSequence)message).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    DefaultUIController.this.toDismissDialog((Dialog)DefaultUIController.this.mConfirmDialog);
                    DefaultUIController.this.toCancelJsresult(DefaultUIController.this.mJsResult);
                }
            }).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    DefaultUIController.this.toDismissDialog((Dialog)DefaultUIController.this.mConfirmDialog);
                    if (DefaultUIController.this.mJsResult != null) {
                        DefaultUIController.this.mJsResult.confirm();
                    }
                }
            }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    dialog.dismiss();
                    DefaultUIController.this.toCancelJsresult(DefaultUIController.this.mJsResult);
                }
            }).create();
        }
        this.mConfirmDialog.setMessage((CharSequence)message);
        this.mJsResult = jsResult;
        this.mConfirmDialog.show();
    }

    private void onJsPromptInternal(String message, String defaultValue, JsPromptResult jsPromptResult) {
        Activity mActivity = this.mActivity;
        if (mActivity == null || mActivity.isFinishing()) {
            jsPromptResult.cancel();
            return;
        }
        if (this.mPromptDialog == null) {
            final EditText et = new EditText((Context)mActivity);
            et.setText((CharSequence)defaultValue);
            this.mPromptDialog = new AlertDialog.Builder((Context)mActivity).setView((View)et).setTitle((CharSequence)message).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    DefaultUIController.this.toDismissDialog((Dialog)DefaultUIController.this.mPromptDialog);
                    DefaultUIController.this.toCancelJsresult((JsResult)DefaultUIController.this.mJsPromptResult);
                }
            }).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    DefaultUIController.this.toDismissDialog((Dialog)DefaultUIController.this.mPromptDialog);
                    if (DefaultUIController.this.mJsPromptResult != null) {
                        DefaultUIController.this.mJsPromptResult.confirm(et.getText().toString());
                    }
                }
            }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    dialog.dismiss();
                    DefaultUIController.this.toCancelJsresult((JsResult)DefaultUIController.this.mJsPromptResult);
                }
            }).create();
        }
        this.mJsPromptResult = jsPromptResult;
        this.mPromptDialog.show();
    }

    @Override
    public void onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult jsPromptResult) {
        this.onJsPromptInternal(message, defaultValue, jsPromptResult);
    }

    @Override
    public void onMainFrameError(WebView view, int errorCode, String description, String failingUrl) {
        LogUtils.i(this.TAG, "mWebParentLayout onMainFrameError:" + this.mWebParentLayout);
        if (this.mWebParentLayout != null) {
            this.mWebParentLayout.showPageMainFrameError();
        }
    }

    @Override
    public void onShowMainFrame() {
        if (this.mWebParentLayout != null) {
            this.mWebParentLayout.hideErrorLayout();
        }
    }

    @Override
    public void onLoading(String msg) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog((Context)this.mActivity);
        }
        this.mProgressDialog.setCancelable(false);
        this.mProgressDialog.setCanceledOnTouchOutside(false);
        this.mProgressDialog.setMessage((CharSequence)msg);
        this.mProgressDialog.show();
    }

    @Override
    public void onCancelLoading() {
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        this.mProgressDialog = null;
    }

    @Override
    public void onShowMessage(String message, String from) {
        if (!TextUtils.isEmpty((CharSequence)from) && from.contains("performDownload")) {
            return;
        }
        AgentWebUtils.toastShowShort(this.mActivity.getApplicationContext(), message);
    }

    @Override
    public void onPermissionsDeny(String[] permissions, String permissionType, String action) {
    }

    private void toCancelJsresult(JsResult result) {
        if (result != null) {
            result.cancel();
        }
    }

    @Override
    protected void bindSupportWebParent(WebParentLayout webParentLayout, Activity activity) {
        this.mActivity = activity;
        this.mWebParentLayout = webParentLayout;
        this.mResources = this.mActivity.getResources();
    }
}

