/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.webkit.HttpAuthHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.alipay.sdk.app.H5PayCallback;
import com.alipay.sdk.app.PayTask;
import com.alipay.sdk.util.H5PayResultModel;
import com.just.agentweb.AbsAgentWebUIController;
import com.just.agentweb.AgentWebConfig;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.LogUtils;
import com.just.agentweb.MiddlewareWebClientBase;
import com.just.agentweb.PermissionInterceptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultWebClient
extends MiddlewareWebClientBase {
    private WeakReference<Activity> mWeakReference = null;
    private static final int CONSTANTS_ABNORMAL_BIG = 7;
    private WebViewClient mWebViewClient;
    private boolean webClientHelper = true;
    public static final String INTENT_SCHEME = "intent://";
    public static final String WEBCHAT_PAY_SCHEME = "weixin://wap/pay?";
    public static final String ALIPAYS_SCHEME = "alipays://";
    public static final String HTTP_SCHEME = "http://";
    public static final String HTTPS_SCHEME = "https://";
    private static final boolean HAS_ALIPAY_LIB;
    private static final String TAG;
    public static final int DERECT_OPEN_OTHER_PAGE = 1001;
    public static final int ASK_USER_OPEN_OTHER_PAGE = 250;
    public static final int DISALLOW_OPEN_OTHER_APP = 62;
    private int mUrlHandleWays = 250;
    private boolean mIsInterceptUnkownUrl = true;
    private WeakReference<AbsAgentWebUIController> mAgentWebUIController = null;
    private WebView mWebView;
    private Handler.Callback mCallback = null;
    private Method onMainFrameErrorMethod = null;
    private Object mPayTask;
    public static final String SCHEME_SMS = "sms:";
    private Set<String> mErrorUrlsSet = new HashSet<String>();
    private Set<String> mWaittingFinishSet = new HashSet<String>();

    DefaultWebClient(Builder builder) {
        super(builder.mClient);
        this.mWebView = builder.mWebView;
        this.mWebViewClient = builder.mClient;
        this.mWeakReference = new WeakReference<Activity>(builder.mActivity);
        this.webClientHelper = builder.mWebClientHelper;
        this.mAgentWebUIController = new WeakReference<AbsAgentWebUIController>(AgentWebUtils.getAgentWebUIControllerByWebView(builder.mWebView));
        this.mIsInterceptUnkownUrl = builder.mIsInterceptUnkownScheme;
        this.mUrlHandleWays = builder.mUrlHandleWays <= 0 ? 250 : builder.mUrlHandleWays;
    }

    @Override
    @RequiresApi(api=21)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        String url = request.getUrl().toString();
        if (url.startsWith(HTTP_SCHEME) || url.startsWith(HTTPS_SCHEME)) {
            return this.webClientHelper && HAS_ALIPAY_LIB && this.isAlipay(view, url);
        }
        if (!this.webClientHelper) {
            return super.shouldOverrideUrlLoading(view, request);
        }
        if (this.handleCommonLink(url)) {
            return true;
        }
        if (url.startsWith(INTENT_SCHEME)) {
            this.handleIntentUrl(url);
            LogUtils.i(TAG, "intent url ");
            return true;
        }
        if (url.startsWith(WEBCHAT_PAY_SCHEME)) {
            LogUtils.i(TAG, "lookup wechat to pay ~~");
            this.startActivity(url);
            return true;
        }
        if (url.startsWith(ALIPAYS_SCHEME) && this.lookup(url)) {
            LogUtils.i(TAG, "alipays url lookup alipay ~~ ");
            return true;
        }
        if (this.queryActiviesNumber(url) > 0 && this.deepLink(url)) {
            LogUtils.i(TAG, "intercept url:" + url);
            return true;
        }
        if (this.mIsInterceptUnkownUrl) {
            LogUtils.i(TAG, "intercept UnkownUrl :" + request.getUrl());
            return true;
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        return super.shouldInterceptRequest(view, url);
    }

    @Override
    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        super.onReceivedHttpAuthRequest(view, handler, host, realm);
    }

    private boolean deepLink(String url) {
        switch (this.mUrlHandleWays) {
            case 1001: {
                this.lookup(url);
                return true;
            }
            case 250: {
                Activity mActivity = null;
                mActivity = (Activity)this.mWeakReference.get();
                if (mActivity == null) {
                    return false;
                }
                ResolveInfo resolveInfo = this.lookupResolveInfo(url);
                if (null == resolveInfo) {
                    return false;
                }
                ActivityInfo activityInfo = resolveInfo.activityInfo;
                LogUtils.e(TAG, "resolve package:" + resolveInfo.activityInfo.packageName + " app package:" + mActivity.getPackageName());
                if (activityInfo != null && !TextUtils.isEmpty((CharSequence)activityInfo.packageName) && activityInfo.packageName.equals(mActivity.getPackageName())) {
                    return this.lookup(url);
                }
                if (this.mAgentWebUIController.get() != null) {
                    ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onOpenPagePrompt(this.mWebView, this.mWebView.getUrl(), this.getCallback(url));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        return super.shouldInterceptRequest(view, request);
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (url.startsWith(HTTP_SCHEME) || url.startsWith(HTTPS_SCHEME)) {
            return this.webClientHelper && HAS_ALIPAY_LIB && this.isAlipay(view, url);
        }
        if (!this.webClientHelper) {
            return false;
        }
        if (this.handleCommonLink(url)) {
            return true;
        }
        if (url.startsWith(INTENT_SCHEME)) {
            this.handleIntentUrl(url);
            return true;
        }
        if (url.startsWith(WEBCHAT_PAY_SCHEME)) {
            this.startActivity(url);
            return true;
        }
        if (url.startsWith(ALIPAYS_SCHEME) && this.lookup(url)) {
            return true;
        }
        if (this.queryActiviesNumber(url) > 0 && this.deepLink(url)) {
            LogUtils.i(TAG, "intercept OtherAppScheme");
            return true;
        }
        if (this.mIsInterceptUnkownUrl) {
            LogUtils.i(TAG, "intercept InterceptUnkownScheme : " + url);
            return true;
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    private int queryActiviesNumber(String url) {
        try {
            if (this.mWeakReference.get() == null) {
                return 0;
            }
            Intent intent = Intent.parseUri((String)url, (int)1);
            PackageManager mPackageManager = ((Activity)this.mWeakReference.get()).getPackageManager();
            List mResolveInfos = mPackageManager.queryIntentActivities(intent, 65536);
            return mResolveInfos == null ? 0 : mResolveInfos.size();
        }
        catch (URISyntaxException ignore) {
            if (LogUtils.isDebug()) {
                ignore.printStackTrace();
            }
            return 0;
        }
    }

    private void handleIntentUrl(String intentUrl) {
        block4: {
            try {
                Object intent = null;
                if (TextUtils.isEmpty((CharSequence)intentUrl) || !intentUrl.startsWith(INTENT_SCHEME)) {
                    return;
                }
                if (this.lookup(intentUrl)) {
                    return;
                }
            }
            catch (Throwable e) {
                if (!LogUtils.isDebug()) break block4;
                e.printStackTrace();
            }
        }
    }

    private ResolveInfo lookupResolveInfo(String url) {
        try {
            Activity mActivity = null;
            mActivity = (Activity)this.mWeakReference.get();
            if (mActivity == null) {
                return null;
            }
            PackageManager packageManager = mActivity.getPackageManager();
            Intent intent = Intent.parseUri((String)url, (int)1);
            ResolveInfo info = packageManager.resolveActivity(intent, 65536);
            return info;
        }
        catch (Throwable ignore) {
            if (LogUtils.isDebug()) {
                ignore.printStackTrace();
            }
            return null;
        }
    }

    private boolean lookup(String url) {
        block4: {
            try {
                Intent intent;
                Activity mActivity = null;
                mActivity = (Activity)this.mWeakReference.get();
                if (mActivity == null) {
                    return true;
                }
                PackageManager packageManager = mActivity.getPackageManager();
                ResolveInfo info = packageManager.resolveActivity(intent = Intent.parseUri((String)url, (int)1), 65536);
                if (info != null) {
                    mActivity.startActivity(intent);
                    return true;
                }
            }
            catch (Throwable ignore) {
                if (!LogUtils.isDebug()) break block4;
                ignore.printStackTrace();
            }
        }
        return false;
    }

    private boolean isAlipay(final WebView view, String url) {
        try {
            PayTask task;
            boolean isIntercepted;
            Activity mActivity = null;
            mActivity = (Activity)this.mWeakReference.get();
            if (mActivity == null) {
                return false;
            }
            if (this.mPayTask == null) {
                Class<?> clazz = Class.forName("com.alipay.sdk.app.PayTask");
                Constructor<?> mConstructor = clazz.getConstructor(Activity.class);
                this.mPayTask = mConstructor.newInstance(mActivity);
            }
            if (isIntercepted = (task = (PayTask)this.mPayTask).payInterceptorWithUrl(url, true, new H5PayCallback(){

                public void onPayResult(H5PayResultModel result) {
                    final String url = result.getReturnUrl();
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        AgentWebUtils.runInUiThread(new Runnable(){

                            @Override
                            public void run() {
                                view.loadUrl(url);
                            }
                        });
                    }
                }
            })) {
                LogUtils.i(TAG, "alipay-isIntercepted:" + isIntercepted + "  url:" + url);
            }
            return isIntercepted;
        }
        catch (Throwable ignore) {
            if (AgentWebConfig.DEBUG) {
                ignore.printStackTrace();
            }
            return false;
        }
    }

    private boolean handleCommonLink(String url) {
        if (url.startsWith("tel:") || url.startsWith(SCHEME_SMS) || url.startsWith("mailto:") || url.startsWith("geo:0,0?q=")) {
            block4: {
                try {
                    Activity mActivity = null;
                    mActivity = (Activity)this.mWeakReference.get();
                    if (mActivity == null) {
                        return false;
                    }
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    mActivity.startActivity(intent);
                }
                catch (ActivityNotFoundException ignored) {
                    if (!AgentWebConfig.DEBUG) break block4;
                    ignored.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (!this.mWaittingFinishSet.contains(url)) {
            this.mWaittingFinishSet.add(url);
        }
        super.onPageStarted(view, url, favicon);
    }

    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        LogUtils.i(TAG, "onReceivedError\uff1a" + description + "  CODE:" + errorCode);
        this.onMainFrameError(view, errorCode, description, failingUrl);
    }

    @Override
    @TargetApi(value=23)
    @RequiresApi(api=21)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        if (request.isForMainFrame()) {
            this.onMainFrameError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }
        LogUtils.i(TAG, "onReceivedError:" + error.getDescription() + " code:" + error.getErrorCode());
    }

    private void onMainFrameError(WebView view, int errorCode, String description, String failingUrl) {
        block5: {
            block4: {
                Method mMethod;
                block6: {
                    this.mErrorUrlsSet.add(failingUrl);
                    if (this.mWebViewClient == null || !this.webClientHelper) break block5;
                    mMethod = this.onMainFrameErrorMethod;
                    if (mMethod != null) break block6;
                    this.onMainFrameErrorMethod = mMethod = AgentWebUtils.isExistMethod(this.mWebViewClient, "onMainFrameError", AbsAgentWebUIController.class, WebView.class, Integer.TYPE, String.class, String.class);
                    if (mMethod == null) break block5;
                }
                try {
                    mMethod.invoke((Object)this.mWebViewClient, this.mAgentWebUIController.get(), view, errorCode, description, failingUrl);
                }
                catch (Throwable ignore) {
                    if (!LogUtils.isDebug()) break block4;
                    ignore.printStackTrace();
                }
            }
            return;
        }
        if (this.mAgentWebUIController.get() != null) {
            ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onMainFrameError(view, errorCode, description, failingUrl);
        }
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        if (!this.mErrorUrlsSet.contains(url) && this.mWaittingFinishSet.contains(url)) {
            if (this.mAgentWebUIController.get() != null) {
                ((AbsAgentWebUIController)this.mAgentWebUIController.get()).onShowMainFrame();
            }
        } else {
            view.setVisibility(0);
        }
        if (this.mWaittingFinishSet.contains(url)) {
            this.mWaittingFinishSet.remove(url);
        }
        if (!this.mErrorUrlsSet.isEmpty()) {
            this.mErrorUrlsSet.clear();
        }
        super.onPageFinished(view, url);
    }

    @Override
    public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
        return super.shouldOverrideKeyEvent(view, event);
    }

    private void startActivity(String url) {
        block3: {
            try {
                if (this.mWeakReference.get() == null) {
                    return;
                }
                Intent intent = new Intent();
                intent.setAction("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                ((Activity)this.mWeakReference.get()).startActivity(intent);
            }
            catch (Exception e) {
                if (!LogUtils.isDebug()) break block3;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        super.onReceivedHttpError(view, request, errorResponse);
    }

    @Override
    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        LogUtils.i(TAG, "onScaleChanged:" + oldScale + "   n:" + newScale);
        if (newScale - oldScale > 7.0f) {
            view.setInitialScale((int)(oldScale / newScale * 100.0f));
        }
    }

    private Handler.Callback getCallback(final String url) {
        if (this.mCallback != null) {
            return this.mCallback;
        }
        this.mCallback = new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        DefaultWebClient.this.lookup(url);
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                return true;
            }
        };
        return this.mCallback;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    static {
        TAG = DefaultWebClient.class.getSimpleName();
        boolean tag = true;
        try {
            Class.forName("com.alipay.sdk.app.PayTask");
        }
        catch (Throwable ignore) {
            tag = false;
        }
        HAS_ALIPAY_LIB = tag;
        LogUtils.i(TAG, "HAS_ALIPAY_LIB:" + HAS_ALIPAY_LIB);
    }

    public static enum OpenOtherPageWays {
        DERECT(1001),
        ASK(250),
        DISALLOW(62);

        int code;

        private OpenOtherPageWays(int code) {
            this.code = code;
        }
    }

    public static class Builder {
        private Activity mActivity;
        private WebViewClient mClient;
        private boolean mWebClientHelper;
        private PermissionInterceptor mPermissionInterceptor;
        private WebView mWebView;
        private boolean mIsInterceptUnkownScheme;
        private int mUrlHandleWays;

        public Builder setActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder setClient(WebViewClient client) {
            this.mClient = client;
            return this;
        }

        public Builder setWebClientHelper(boolean webClientHelper) {
            this.mWebClientHelper = webClientHelper;
            return this;
        }

        public Builder setPermissionInterceptor(PermissionInterceptor permissionInterceptor) {
            this.mPermissionInterceptor = permissionInterceptor;
            return this;
        }

        public Builder setWebView(WebView webView) {
            this.mWebView = webView;
            return this;
        }

        public Builder setInterceptUnkownUrl(boolean interceptUnkownScheme) {
            this.mIsInterceptUnkownScheme = interceptUnkownScheme;
            return this;
        }

        public Builder setUrlHandleWays(int urlHandleWays) {
            this.mUrlHandleWays = urlHandleWays;
            return this;
        }

        public DefaultWebClient build() {
            return new DefaultWebClient(this);
        }
    }
}

