/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class BubbleDataSet
extends BarLineScatterCandleBubbleDataSet<BubbleEntry>
implements IBubbleDataSet {
    protected float mMaxSize;
    protected boolean mNormalizeSize = true;
    private float mHighlightCircleWidth = 2.5f;

    public BubbleDataSet(List<BubbleEntry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public void setHighlightCircleWidth(float width) {
        this.mHighlightCircleWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getHighlightCircleWidth() {
        return this.mHighlightCircleWidth;
    }

    @Override
    protected void calcMinMax(BubbleEntry e) {
        super.calcMinMax(e);
        float size = e.getSize();
        if (size > this.mMaxSize) {
            this.mMaxSize = size;
        }
    }

    @Override
    public DataSet<BubbleEntry> copy() {
        ArrayList<BubbleEntry> entries = new ArrayList<BubbleEntry>();
        for (int i = 0; i < this.mValues.size(); ++i) {
            entries.add(((BubbleEntry)this.mValues.get(i)).copy());
        }
        BubbleDataSet copied = new BubbleDataSet((List<BubbleEntry>)entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected void copy(BubbleDataSet bubbleDataSet) {
        bubbleDataSet.mHighlightCircleWidth = this.mHighlightCircleWidth;
        bubbleDataSet.mNormalizeSize = this.mNormalizeSize;
    }

    @Override
    public float getMaxSize() {
        return this.mMaxSize;
    }

    @Override
    public boolean isNormalizeSizeEnabled() {
        return this.mNormalizeSize;
    }

    public void setNormalizeSizeEnabled(boolean normalizeSize) {
        this.mNormalizeSize = normalizeSize;
    }
}

