/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BaseDataSet;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSet<T extends Entry>
extends BaseDataSet<T> {
    protected List<T> mValues = null;
    protected float mYMax = -3.4028235E38f;
    protected float mYMin = Float.MAX_VALUE;
    protected float mXMax = -3.4028235E38f;
    protected float mXMin = Float.MAX_VALUE;

    public DataSet(List<T> values, String label) {
        super(label);
        this.mValues = values;
        if (this.mValues == null) {
            this.mValues = new ArrayList<T>();
        }
        this.calcMinMax();
    }

    @Override
    public void calcMinMax() {
        if (this.mValues == null || this.mValues.isEmpty()) {
            return;
        }
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        for (Entry e : this.mValues) {
            this.calcMinMax(e);
        }
    }

    @Override
    public void calcMinMaxY(float fromX, float toX) {
        if (this.mValues == null || this.mValues.isEmpty()) {
            return;
        }
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        int indexFrom = this.getEntryIndex(fromX, Float.NaN, Rounding.DOWN);
        int indexTo = this.getEntryIndex(toX, Float.NaN, Rounding.UP);
        for (int i = indexFrom; i <= indexTo; ++i) {
            this.calcMinMaxY((Entry)this.mValues.get(i));
        }
    }

    protected void calcMinMax(T e) {
        if (e == null) {
            return;
        }
        this.calcMinMaxX(e);
        this.calcMinMaxY(e);
    }

    protected void calcMinMaxX(T e) {
        if (((Entry)e).getX() < this.mXMin) {
            this.mXMin = ((Entry)e).getX();
        }
        if (((Entry)e).getX() > this.mXMax) {
            this.mXMax = ((Entry)e).getX();
        }
    }

    protected void calcMinMaxY(T e) {
        if (((BaseEntry)e).getY() < this.mYMin) {
            this.mYMin = ((BaseEntry)e).getY();
        }
        if (((BaseEntry)e).getY() > this.mYMax) {
            this.mYMax = ((BaseEntry)e).getY();
        }
    }

    @Override
    public int getEntryCount() {
        return this.mValues.size();
    }

    public List<T> getValues() {
        return this.mValues;
    }

    public void setValues(List<T> values) {
        this.mValues = values;
        this.notifyDataSetChanged();
    }

    public abstract DataSet<T> copy();

    protected void copy(DataSet dataSet) {
        super.copy(dataSet);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toSimpleString());
        for (int i = 0; i < this.mValues.size(); ++i) {
            buffer.append(((Entry)this.mValues.get(i)).toString() + " ");
        }
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSet, label: " + (this.getLabel() == null ? "" : this.getLabel()) + ", entries: " + this.mValues.size() + "\n");
        return buffer.toString();
    }

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    @Override
    public float getXMin() {
        return this.mXMin;
    }

    @Override
    public float getXMax() {
        return this.mXMax;
    }

    @Override
    public void addEntryOrdered(T e) {
        if (e == null) {
            return;
        }
        if (this.mValues == null) {
            this.mValues = new ArrayList<T>();
        }
        this.calcMinMax(e);
        if (this.mValues.size() > 0 && ((Entry)this.mValues.get(this.mValues.size() - 1)).getX() > ((Entry)e).getX()) {
            int closestIndex = this.getEntryIndex(((Entry)e).getX(), ((BaseEntry)e).getY(), Rounding.UP);
            this.mValues.add(closestIndex, e);
        } else {
            this.mValues.add(e);
        }
    }

    @Override
    public void clear() {
        this.mValues.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean addEntry(T e) {
        if (e == null) {
            return false;
        }
        List<T> values = this.getValues();
        if (values == null) {
            values = new ArrayList<T>();
        }
        this.calcMinMax(e);
        return values.add(e);
    }

    @Override
    public boolean removeEntry(T e) {
        if (e == null) {
            return false;
        }
        if (this.mValues == null) {
            return false;
        }
        boolean removed = this.mValues.remove(e);
        if (removed) {
            this.calcMinMax();
        }
        return removed;
    }

    @Override
    public int getEntryIndex(Entry e) {
        return this.mValues.indexOf(e);
    }

    @Override
    public T getEntryForXValue(float xValue, float closestToY, Rounding rounding) {
        int index = this.getEntryIndex(xValue, closestToY, rounding);
        if (index > -1) {
            return (T)((Entry)this.mValues.get(index));
        }
        return null;
    }

    @Override
    public T getEntryForXValue(float xValue, float closestToY) {
        return this.getEntryForXValue(xValue, closestToY, Rounding.CLOSEST);
    }

    @Override
    public T getEntryForIndex(int index) {
        return (T)((Entry)this.mValues.get(index));
    }

    @Override
    public int getEntryIndex(float xValue, float closestToY, Rounding rounding) {
        int high;
        if (this.mValues == null || this.mValues.isEmpty()) {
            return -1;
        }
        int low = 0;
        int closest = high = this.mValues.size() - 1;
        while (low < high) {
            int m = (low + high) / 2;
            float d1 = ((Entry)this.mValues.get(m)).getX() - xValue;
            float d2 = ((Entry)this.mValues.get(m + 1)).getX() - xValue;
            float ad1 = Math.abs(d1);
            float ad2 = Math.abs(d2);
            if (ad2 < ad1) {
                low = m + 1;
            } else if (ad1 < ad2) {
                high = m;
            } else if ((double)d1 >= 0.0) {
                high = m;
            } else if ((double)d1 < 0.0) {
                low = m + 1;
            }
            closest = high;
        }
        if (closest != -1) {
            float closestXValue = ((Entry)this.mValues.get(closest)).getX();
            if (rounding == Rounding.UP) {
                if (closestXValue < xValue && closest < this.mValues.size() - 1) {
                    ++closest;
                }
            } else if (rounding == Rounding.DOWN && closestXValue > xValue && closest > 0) {
                --closest;
            }
            if (!Float.isNaN(closestToY)) {
                Entry value;
                while (closest > 0 && ((Entry)this.mValues.get(closest - 1)).getX() == closestXValue) {
                    --closest;
                }
                float closestYValue = ((Entry)this.mValues.get(closest)).getY();
                int closestYIndex = closest;
                while (++closest < this.mValues.size() && (value = (Entry)this.mValues.get(closest)).getX() == closestXValue) {
                    if (!(Math.abs(value.getY() - closestToY) < Math.abs(closestYValue - closestToY))) continue;
                    closestYValue = closestToY;
                    closestYIndex = closest;
                }
                closest = closestYIndex;
            }
        }
        return closest;
    }

    @Override
    public List<T> getEntriesForXValue(float xValue) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int low = 0;
        int high = this.mValues.size() - 1;
        while (low <= high) {
            int m = (high + low) / 2;
            Entry entry = (Entry)this.mValues.get(m);
            if (xValue == entry.getX()) {
                while (m > 0 && ((Entry)this.mValues.get(m - 1)).getX() == xValue) {
                    --m;
                }
                high = this.mValues.size();
                while (m < high && (entry = (Entry)this.mValues.get(m)).getX() == xValue) {
                    entries.add(entry);
                    ++m;
                }
                break;
            }
            if (xValue > entry.getX()) {
                low = m + 1;
                continue;
            }
            high = m - 1;
        }
        return entries;
    }

    public static enum Rounding {
        UP,
        DOWN,
        CLOSEST;

    }
}

