/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.renderer.scatter.IShapeRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    protected ScatterDataProvider mChart;
    float[] mPixelBuffer = new float[2];

    public ScatterChartRenderer(ScatterDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (IScatterDataSet set : scatterData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, IScatterDataSet dataSet) {
        ViewPortHandler viewPortHandler = this.mViewPortHandler;
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.mAnimator.getPhaseY();
        IShapeRenderer renderer = dataSet.getShapeRenderer();
        if (renderer == null) {
            Log.i((String)"MISSING", (String)"There's no IShapeRenderer specified for ScatterDataSet");
            return;
        }
        int max = (int)Math.min(Math.ceil((float)dataSet.getEntryCount() * this.mAnimator.getPhaseX()), (double)dataSet.getEntryCount());
        for (int i = 0; i < max; ++i) {
            Object e = dataSet.getEntryForIndex(i);
            this.mPixelBuffer[0] = ((Entry)e).getX();
            this.mPixelBuffer[1] = ((BaseEntry)e).getY() * phaseY;
            trans.pointValuesToPixel(this.mPixelBuffer);
            if (!viewPortHandler.isInBoundsRight(this.mPixelBuffer[0])) break;
            if (!viewPortHandler.isInBoundsLeft(this.mPixelBuffer[0]) || !viewPortHandler.isInBoundsY(this.mPixelBuffer[1])) continue;
            this.mRenderPaint.setColor(dataSet.getColor(i / 2));
            renderer.renderShape(c, dataSet, this.mViewPortHandler, this.mPixelBuffer[0], this.mPixelBuffer[1], this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getScatterData().getDataSets();
            for (int i = 0; i < this.mChart.getScatterData().getDataSetCount(); ++i) {
                IScatterDataSet dataSet = (IScatterDataSet)dataSets.get(i);
                if (!this.shouldDrawValues(dataSet)) continue;
                this.applyValueTextStyle(dataSet);
                this.mXBounds.set(this.mChart, dataSet);
                float[] positions = this.mChart.getTransformer(dataSet.getAxisDependency()).generateTransformedValuesScatter(dataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), this.mXBounds.min, this.mXBounds.max);
                float shapeSize = Utils.convertDpToPixel(dataSet.getScatterShapeSize());
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                for (int j = 0; j < positions.length && this.mViewPortHandler.isInBoundsRight(positions[j]); j += 2) {
                    if (!this.mViewPortHandler.isInBoundsLeft(positions[j]) || !this.mViewPortHandler.isInBoundsY(positions[j + 1])) continue;
                    Object entry = dataSet.getEntryForIndex(j / 2 + this.mXBounds.min);
                    if (dataSet.isDrawValuesEnabled()) {
                        this.drawValue(c, dataSet.getValueFormatter(), ((BaseEntry)entry).getY(), (Entry)entry, i, positions[j], positions[j + 1] - shapeSize, dataSet.getValueTextColor(j / 2 + this.mXBounds.min));
                    }
                    if (((BaseEntry)entry).getIcon() == null || !dataSet.isDrawIconsEnabled()) continue;
                    Drawable icon = ((BaseEntry)entry).getIcon();
                    Utils.drawImage(c, icon, (int)(positions[j] + iconsOffset.x), (int)(positions[j + 1] + iconsOffset.y), icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        ScatterData scatterData = this.mChart.getScatterData();
        for (Highlight high : indices) {
            Object e;
            IScatterDataSet set = (IScatterDataSet)scatterData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX((Entry)(e = set.getEntryForXValue(high.getX(), high.getY())), set)) continue;
            MPPointD pix = this.mChart.getTransformer(set.getAxisDependency()).getPixelForValues(((Entry)e).getX(), ((BaseEntry)e).getY() * this.mAnimator.getPhaseY());
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }
}

