/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.support.design.widget.BottomSheetDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebView;
import android.widget.TextView;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.DefaultUIController;
import com.just.agentweb.LogUtils;
import com.just.agentweb.R;
import com.just.agentweb.WebParentLayout;

public class DefaultDesignUIController
extends DefaultUIController {
    private BottomSheetDialog mBottomSheetDialog;
    private static final int RECYCLERVIEW_ID = 4097;
    private Activity mActivity = null;
    private WebParentLayout mWebParentLayout;
    private LayoutInflater mLayoutInflater;

    @Override
    public void onJsAlert(WebView view, String url, String message) {
        this.onJsAlertInternal(view, message);
    }

    private void onJsAlertInternal(WebView view, String message) {
        block3: {
            Activity mActivity = this.mActivity;
            if (mActivity == null || mActivity.isFinishing()) {
                return;
            }
            try {
                AgentWebUtils.show((View)view, message, -1, -1, mActivity.getResources().getColor(R.color.black), null, -1, null);
            }
            catch (Throwable throwable) {
                if (!LogUtils.isDebug()) break block3;
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void onJsConfirm(WebView view, String url, String message, JsResult jsResult) {
        super.onJsConfirm(view, url, message, jsResult);
    }

    @Override
    public void onSelectItemsPrompt(WebView view, String url, String[] ways, Handler.Callback callback) {
        this.showChooserInternal(view, url, ways, callback);
    }

    @Override
    public void onForceDownloadAlert(String url, Handler.Callback callback) {
        super.onForceDownloadAlert(url, callback);
    }

    private void showChooserInternal(WebView view, String url, String[] ways, final Handler.Callback callback) {
        RecyclerView mRecyclerView;
        LogUtils.i(this.TAG, "url:" + url + "  ways:" + ways[0]);
        if (this.mBottomSheetDialog == null) {
            this.mBottomSheetDialog = new BottomSheetDialog((Context)this.mActivity);
            mRecyclerView = new RecyclerView((Context)this.mActivity);
            mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.mActivity));
            mRecyclerView.setId(4097);
            this.mBottomSheetDialog.setContentView((View)mRecyclerView);
        }
        mRecyclerView = (RecyclerView)this.mBottomSheetDialog.getDelegate().findViewById(4097);
        mRecyclerView.setAdapter(this.getAdapter(ways, callback));
        this.mBottomSheetDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (callback != null) {
                    callback.handleMessage(Message.obtain(null, (int)-1));
                }
            }
        });
        this.mBottomSheetDialog.show();
    }

    private RecyclerView.Adapter getAdapter(final String[] ways, final Handler.Callback callback) {
        return new RecyclerView.Adapter<BottomSheetHolder>(){

            public BottomSheetHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
                return new BottomSheetHolder(DefaultDesignUIController.this.mLayoutInflater.inflate(17367043, viewGroup, false));
            }

            public void onBindViewHolder(BottomSheetHolder bottomSheetHolder, final int i) {
                TypedValue outValue = new TypedValue();
                DefaultDesignUIController.this.mActivity.getTheme().resolveAttribute(16843534, outValue, true);
                bottomSheetHolder.mTextView.setBackgroundResource(outValue.resourceId);
                bottomSheetHolder.mTextView.setText((CharSequence)ways[i]);
                bottomSheetHolder.mTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (DefaultDesignUIController.this.mBottomSheetDialog != null && DefaultDesignUIController.this.mBottomSheetDialog.isShowing()) {
                            DefaultDesignUIController.this.mBottomSheetDialog.dismiss();
                        }
                        Message mMessage = Message.obtain();
                        mMessage.what = i;
                        callback.handleMessage(mMessage);
                    }
                });
            }

            public int getItemCount() {
                return ways.length;
            }
        };
    }

    @Override
    public void onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult jsPromptResult) {
        super.onJsPrompt(view, url, message, defaultValue, jsPromptResult);
    }

    @Override
    protected void bindSupportWebParent(WebParentLayout webParentLayout, Activity activity) {
        super.bindSupportWebParent(webParentLayout, activity);
        this.mActivity = activity;
        this.mWebParentLayout = webParentLayout;
        this.mLayoutInflater = LayoutInflater.from((Context)this.mActivity);
    }

    @Override
    public void onShowMessage(String message, String from) {
        if (!TextUtils.isEmpty((CharSequence)from) && from.contains("performDownload")) {
            return;
        }
        this.onJsAlertInternal(this.mWebParentLayout.getWebView(), message);
    }

    private static class BottomSheetHolder
    extends RecyclerView.ViewHolder {
        TextView mTextView;

        public BottomSheetHolder(View itemView) {
            super(itemView);
            this.mTextView = (TextView)itemView.findViewById(16908308);
        }
    }
}

