/*
 * Decompiled with CFR 0.152.
 */
package com.chinaums.pppay.unify;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.util.Log;
import android.util.Xml;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public class UnifyUtils {
    private static final String ALIPAY_PACKAGE_NAME = "com.eg.android.AlipayGphone";
    private static final String INTENT_URL_FORMAT = "intent://platformapi/startapp?saId=10000007&clientVersion=3.7.0.0718&qrcode=https%3A%2F%2Fqr.alipay.com%2F{urlCode}%3F_s%3Dweb-other&_t=1472443966571#Intent;scheme=alipayqr;package=com.eg.android.AlipayGphone;end";

    public static void buildPayParams(StringBuilder stringBuilder, Map map, boolean bl) {
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            stringBuilder.append(string).append("=");
            if (bl) {
                stringBuilder.append(UnifyUtils.urlEncode((String)map.get(string)));
            } else {
                stringBuilder.append((String)map.get(string));
            }
            stringBuilder.append("&");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 1);
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String toXml(Map map) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        stringBuilder2.append("<xml>");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            StringBuilder stringBuilder3 = stringBuilder2;
            String string = (String)iterator.next();
            stringBuilder3.append("<").append(string).append(">");
            stringBuilder3.append("<![CDATA[").append((String)map.get(string)).append("]]>");
            stringBuilder3.append("</").append(string).append(">\n");
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append("</xml>");
        return stringBuilder4.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> decodeXml(String string) {
        try {
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2 = hashMap;
            hashMap = new HashMap<String, String>();
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput((Reader)new StringReader(string));
            int n = xmlPullParser.getEventType();
            while (true) {
                if (n == 1) {
                    return hashMap2;
                }
                String string2 = xmlPullParser.getName();
                if (n != 0 && n == 2 && !"xml".equals(string2)) {
                    hashMap2.put(string2, xmlPullParser.nextText());
                }
                n = xmlPullParser.next();
            }
        }
        catch (Exception exception) {
            Log.e((String)"Simon", (String)("----" + exception.toString()));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toJson(Object object, Class<?> fieldArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append(fieldArray.getSimpleName() + "[");
        fieldArray = fieldArray.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append("]");
                Log.d((String)"ddebug", (String)(UnifyUtils.class.getSimpleName() + "toJson result = " + stringBuilder2.toString()));
                return stringBuilder3.toString();
            }
            Field field = fieldArray[n2];
            field.setAccessible(true);
            try {
                String string;
                StringBuilder stringBuilder4;
                if (field == fieldArray[fieldArray.length - 1]) {
                    stringBuilder4 = stringBuilder2;
                    string = field.getName() + ":" + field.get(object);
                } else {
                    stringBuilder4 = stringBuilder2;
                    string = field.getName() + ":" + field.get(object) + ", ";
                }
                stringBuilder4.append(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                Log.d((String)"ddebug", (String)(UnifyUtils.class.getSimpleName() + "toJson e.printStackTrace()"));
            }
            ++n2;
        }
    }

    public static boolean hasInstalledAlipayClient(Context context) {
        try {
            return context.getPackageManager().getPackageInfo(ALIPAY_PACKAGE_NAME, 0) != null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
    }

    public static boolean startAlipayClient(Context context, String string) {
        return UnifyUtils.startIntentUrl(context, INTENT_URL_FORMAT.replace("{urlCode}", string));
    }

    public static boolean startIntentUrl(Context context, String string) {
        try {
            context.startActivity(Intent.parseUri((String)string, (int)1));
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            activityNotFoundException.printStackTrace();
            return false;
        }
    }

    public static String createResultInfo(String string, String string2, String string3) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("resultMsg", (Object)string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
        jSONObject.put("extraMsg", (Object)string2);
        jSONObject.put("rawMsg", (Object)string3);
        return jSONObject.toString();
    }
}

