/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.support.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.bumptech.glide.signature.ObjectKey;

public class UnitModelLoader<Model>
implements ModelLoader<Model, Model> {
    private static final UnitModelLoader<?> INSTANCE = new UnitModelLoader();

    public static <T> UnitModelLoader<T> getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public UnitModelLoader() {
    }

    @Override
    public ModelLoader.LoadData<Model> buildLoadData(@NonNull Model model, int width, int height, @NonNull Options options) {
        return new ModelLoader.LoadData<Model>(new ObjectKey(model), new UnitFetcher<Model>(model));
    }

    @Override
    public boolean handles(@NonNull Model model) {
        return true;
    }

    public static class Factory<Model>
    implements ModelLoaderFactory<Model, Model> {
        private static final Factory<?> FACTORY = new Factory();

        public static <T> Factory<T> getInstance() {
            return FACTORY;
        }

        @Deprecated
        public Factory() {
        }

        @Override
        @NonNull
        public ModelLoader<Model, Model> build(MultiModelLoaderFactory multiFactory) {
            return UnitModelLoader.getInstance();
        }

        @Override
        public void teardown() {
        }
    }

    private static class UnitFetcher<Model>
    implements DataFetcher<Model> {
        private final Model resource;

        UnitFetcher(Model resource) {
            this.resource = resource;
        }

        @Override
        public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super Model> callback) {
            callback.onDataReady(this.resource);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<Model> getDataClass() {
            return this.resource.getClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }
}

