/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.support.annotation.NonNull;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.engine.DataFetcherGenerator;
import com.bumptech.glide.load.engine.DecodeHelper;
import com.bumptech.glide.load.engine.ResourceCacheKey;
import com.bumptech.glide.load.model.ModelLoader;
import java.io.File;
import java.util.List;

class ResourceCacheGenerator
implements DataFetcherGenerator,
DataFetcher.DataCallback<Object> {
    private final DataFetcherGenerator.FetcherReadyCallback cb;
    private final DecodeHelper<?> helper;
    private int sourceIdIndex;
    private int resourceClassIndex = -1;
    private Key sourceKey;
    private List<ModelLoader<File, ?>> modelLoaders;
    private int modelLoaderIndex;
    private volatile ModelLoader.LoadData<?> loadData;
    private File cacheFile;
    private ResourceCacheKey currentKey;

    ResourceCacheGenerator(DecodeHelper<?> helper, DataFetcherGenerator.FetcherReadyCallback cb) {
        this.helper = helper;
        this.cb = cb;
    }

    @Override
    public boolean startNext() {
        List<Key> sourceIds = this.helper.getCacheKeys();
        if (sourceIds.isEmpty()) {
            return false;
        }
        List<Class<?>> resourceClasses = this.helper.getRegisteredResourceClasses();
        if (resourceClasses.isEmpty() && File.class.equals(this.helper.getTranscodeClass())) {
            return false;
        }
        while (this.modelLoaders == null || !this.hasNextModelLoader()) {
            ++this.resourceClassIndex;
            if (this.resourceClassIndex >= resourceClasses.size()) {
                ++this.sourceIdIndex;
                if (this.sourceIdIndex >= sourceIds.size()) {
                    return false;
                }
                this.resourceClassIndex = 0;
            }
            Key sourceId = sourceIds.get(this.sourceIdIndex);
            Class<?> resourceClass = resourceClasses.get(this.resourceClassIndex);
            Transformation<?> transformation = this.helper.getTransformation(resourceClass);
            this.currentKey = new ResourceCacheKey(this.helper.getArrayPool(), sourceId, this.helper.getSignature(), this.helper.getWidth(), this.helper.getHeight(), transformation, resourceClass, this.helper.getOptions());
            this.cacheFile = this.helper.getDiskCache().get(this.currentKey);
            if (this.cacheFile == null) continue;
            this.sourceKey = sourceId;
            this.modelLoaders = this.helper.getModelLoaders(this.cacheFile);
            this.modelLoaderIndex = 0;
        }
        this.loadData = null;
        boolean started = false;
        while (!started && this.hasNextModelLoader()) {
            ModelLoader<File, ?> modelLoader = this.modelLoaders.get(this.modelLoaderIndex++);
            this.loadData = modelLoader.buildLoadData(this.cacheFile, this.helper.getWidth(), this.helper.getHeight(), this.helper.getOptions());
            if (this.loadData == null || !this.helper.hasLoadPath(this.loadData.fetcher.getDataClass())) continue;
            started = true;
            this.loadData.fetcher.loadData(this.helper.getPriority(), this);
        }
        return started;
    }

    private boolean hasNextModelLoader() {
        return this.modelLoaderIndex < this.modelLoaders.size();
    }

    @Override
    public void cancel() {
        ModelLoader.LoadData<?> local = this.loadData;
        if (local != null) {
            local.fetcher.cancel();
        }
    }

    @Override
    public void onDataReady(Object data) {
        this.cb.onDataFetcherReady(this.sourceKey, data, this.loadData.fetcher, DataSource.RESOURCE_DISK_CACHE, this.currentKey);
    }

    @Override
    public void onLoadFailed(@NonNull Exception e) {
        this.cb.onDataFetcherFailed(this.currentKey, e, this.loadData.fetcher, DataSource.RESOURCE_DISK_CACHE);
    }
}

