/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProviderWithDependencies;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.shiro.guice.web.SimpleFilterChainResolver;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;

@Singleton
class FilterChainResolverProvider
implements ProviderWithDependencies<FilterChainResolver> {
    @Inject
    Injector injector;
    private final Map<String, Key<? extends Filter>[]> chains;
    private final Set<Dependency<?>> dependencies;
    private PatternMatcher patternMatcher = new AntPathMatcher();

    public FilterChainResolverProvider(Map<String, Key<? extends Filter>[]> chains) {
        this.chains = chains;
        HashSet<Dependency> dependenciesBuilder = new HashSet<Dependency>();
        for (String chain : chains.keySet()) {
            for (Key<? extends Filter> filterKey : chains.get(chain)) {
                dependenciesBuilder.add(Dependency.get(filterKey));
            }
        }
        this.dependencies = Collections.unmodifiableSet(dependenciesBuilder);
    }

    @Inject(optional=true)
    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public FilterChainResolver get() {
        return new SimpleFilterChainResolver(this.chains, this.injector, this.patternMatcher);
    }
}

