/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data.mediastore;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.data.ExifOrientationStream;
import com.bumptech.glide.load.data.mediastore.ThumbnailQuery;
import com.bumptech.glide.load.data.mediastore.ThumbnailStreamOpener;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ThumbFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "MediaStoreThumbFetcher";
    private final Uri mediaStoreImageUri;
    private final ThumbnailStreamOpener opener;
    private InputStream inputStream;

    public static ThumbFetcher buildImageFetcher(Context context, Uri uri) {
        return ThumbFetcher.build(context, uri, new ImageThumbnailQuery(context.getContentResolver()));
    }

    public static ThumbFetcher buildVideoFetcher(Context context, Uri uri) {
        return ThumbFetcher.build(context, uri, new VideoThumbnailQuery(context.getContentResolver()));
    }

    private static ThumbFetcher build(Context context, Uri uri, ThumbnailQuery query) {
        ArrayPool byteArrayPool = Glide.get(context).getArrayPool();
        ThumbnailStreamOpener opener = new ThumbnailStreamOpener(Glide.get(context).getRegistry().getImageHeaderParsers(), query, byteArrayPool, context.getContentResolver());
        return new ThumbFetcher(uri, opener);
    }

    @VisibleForTesting
    ThumbFetcher(Uri mediaStoreImageUri, ThumbnailStreamOpener opener) {
        this.mediaStoreImageUri = mediaStoreImageUri;
        this.opener = opener;
    }

    @Override
    public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super InputStream> callback) {
        try {
            this.inputStream = this.openThumbInputStream();
        }
        catch (FileNotFoundException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to find thumbnail file", (Throwable)e);
            }
            callback.onLoadFailed(e);
            return;
        }
        callback.onDataReady(this.inputStream);
    }

    private InputStream openThumbInputStream() throws FileNotFoundException {
        InputStream result = this.opener.open(this.mediaStoreImageUri);
        int orientation = -1;
        if (result != null) {
            orientation = this.opener.getOrientation(this.mediaStoreImageUri);
        }
        if (orientation != -1) {
            result = new ExifOrientationStream(result, orientation);
        }
        return result;
    }

    @Override
    public void cleanup() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    @NonNull
    public Class<InputStream> getDataClass() {
        return InputStream.class;
    }

    @Override
    @NonNull
    public DataSource getDataSource() {
        return DataSource.LOCAL;
    }

    static class ImageThumbnailQuery
    implements ThumbnailQuery {
        private final ContentResolver contentResolver;
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND image_id = ?";

        ImageThumbnailQuery(ContentResolver contentResolver) {
            this.contentResolver = contentResolver;
        }

        @Override
        public Cursor query(Uri uri) {
            String imageId = uri.getLastPathSegment();
            return this.contentResolver.query(MediaStore.Images.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{imageId}, null);
        }
    }

    static class VideoThumbnailQuery
    implements ThumbnailQuery {
        private final ContentResolver contentResolver;
        private static final String[] PATH_PROJECTION = new String[]{"_data"};
        private static final String PATH_SELECTION = "kind = 1 AND video_id = ?";

        VideoThumbnailQuery(ContentResolver contentResolver) {
            this.contentResolver = contentResolver;
        }

        @Override
        public Cursor query(Uri uri) {
            String videoId = uri.getLastPathSegment();
            return this.contentResolver.query(MediaStore.Video.Thumbnails.EXTERNAL_CONTENT_URI, PATH_PROJECTION, PATH_SELECTION, new String[]{videoId}, null);
        }
    }
}

