/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.util.CachedHashCodeArrayMap;
import java.security.MessageDigest;

public final class Options
implements Key {
    private final ArrayMap<Option<?>, Object> values = new CachedHashCodeArrayMap();

    public void putAll(@NonNull Options other) {
        this.values.putAll(other.values);
    }

    @NonNull
    public <T> Options set(@NonNull Option<T> option, @NonNull T value) {
        this.values.put(option, value);
        return this;
    }

    @Nullable
    public <T> T get(@NonNull Option<T> option) {
        return (T)(this.values.containsKey(option) ? this.values.get(option) : option.getDefaultValue());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Options) {
            Options other = (Options)o;
            return this.values.equals(other.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        for (int i = 0; i < this.values.size(); ++i) {
            Option key = (Option)this.values.keyAt(i);
            Object value = this.values.valueAt(i);
            Options.updateDiskCacheKey(key, value, messageDigest);
        }
    }

    public String toString() {
        return "Options{values=" + this.values + '}';
    }

    private static <T> void updateDiskCacheKey(@NonNull Option<T> option, @NonNull Object value, @NonNull MessageDigest md) {
        option.update(value, md);
    }
}

