/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.support.annotation.NonNull;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.engine.DataCacheKey;
import com.bumptech.glide.load.engine.DataFetcherGenerator;
import com.bumptech.glide.load.engine.DecodeHelper;
import com.bumptech.glide.load.model.ModelLoader;
import java.io.File;
import java.util.List;

class DataCacheGenerator
implements DataFetcherGenerator,
DataFetcher.DataCallback<Object> {
    private final List<Key> cacheKeys;
    private final DecodeHelper<?> helper;
    private final DataFetcherGenerator.FetcherReadyCallback cb;
    private int sourceIdIndex = -1;
    private Key sourceKey;
    private List<ModelLoader<File, ?>> modelLoaders;
    private int modelLoaderIndex;
    private volatile ModelLoader.LoadData<?> loadData;
    private File cacheFile;

    DataCacheGenerator(DecodeHelper<?> helper, DataFetcherGenerator.FetcherReadyCallback cb) {
        this(helper.getCacheKeys(), helper, cb);
    }

    DataCacheGenerator(List<Key> cacheKeys, DecodeHelper<?> helper, DataFetcherGenerator.FetcherReadyCallback cb) {
        this.cacheKeys = cacheKeys;
        this.helper = helper;
        this.cb = cb;
    }

    @Override
    public boolean startNext() {
        while (this.modelLoaders == null || !this.hasNextModelLoader()) {
            ++this.sourceIdIndex;
            if (this.sourceIdIndex >= this.cacheKeys.size()) {
                return false;
            }
            Key sourceId = this.cacheKeys.get(this.sourceIdIndex);
            DataCacheKey originalKey = new DataCacheKey(sourceId, this.helper.getSignature());
            this.cacheFile = this.helper.getDiskCache().get(originalKey);
            if (this.cacheFile == null) continue;
            this.sourceKey = sourceId;
            this.modelLoaders = this.helper.getModelLoaders(this.cacheFile);
            this.modelLoaderIndex = 0;
        }
        this.loadData = null;
        boolean started = false;
        while (!started && this.hasNextModelLoader()) {
            ModelLoader<File, ?> modelLoader = this.modelLoaders.get(this.modelLoaderIndex++);
            this.loadData = modelLoader.buildLoadData(this.cacheFile, this.helper.getWidth(), this.helper.getHeight(), this.helper.getOptions());
            if (this.loadData == null || !this.helper.hasLoadPath(this.loadData.fetcher.getDataClass())) continue;
            started = true;
            this.loadData.fetcher.loadData(this.helper.getPriority(), this);
        }
        return started;
    }

    private boolean hasNextModelLoader() {
        return this.modelLoaderIndex < this.modelLoaders.size();
    }

    @Override
    public void cancel() {
        ModelLoader.LoadData<?> local = this.loadData;
        if (local != null) {
            local.fetcher.cancel();
        }
    }

    @Override
    public void onDataReady(Object data) {
        this.cb.onDataFetcherReady(this.sourceKey, data, this.loadData.fetcher, DataSource.DATA_DISK_CACHE, this.sourceKey);
    }

    @Override
    public void onLoadFailed(@NonNull Exception e) {
        this.cb.onDataFetcherFailed(this.sourceKey, e, this.loadData.fetcher, DataSource.DATA_DISK_CACHE);
    }
}

