/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.CheckResult;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.view.View;
import com.bumptech.glide.Glide;
import com.bumptech.glide.ModelTypes;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.manager.ConnectivityMonitor;
import com.bumptech.glide.manager.ConnectivityMonitorFactory;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.LifecycleListener;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.manager.RequestTracker;
import com.bumptech.glide.manager.TargetTracker;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.target.ViewTarget;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.net.URL;

public class RequestManager
implements LifecycleListener,
ModelTypes<RequestBuilder<Drawable>> {
    private static final RequestOptions DECODE_TYPE_BITMAP = RequestOptions.decodeTypeOf(Bitmap.class).lock();
    private static final RequestOptions DECODE_TYPE_GIF = RequestOptions.decodeTypeOf(GifDrawable.class).lock();
    private static final RequestOptions DOWNLOAD_ONLY_OPTIONS = RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.DATA).priority(Priority.LOW).skipMemoryCache(true);
    protected final Glide glide;
    protected final Context context;
    final Lifecycle lifecycle;
    private final RequestTracker requestTracker;
    private final RequestManagerTreeNode treeNode;
    private final TargetTracker targetTracker = new TargetTracker();
    private final Runnable addSelfToLifecycle = new Runnable(){

        @Override
        public void run() {
            RequestManager.this.lifecycle.addListener(RequestManager.this);
        }
    };
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final ConnectivityMonitor connectivityMonitor;
    private RequestOptions requestOptions;

    public RequestManager(@NonNull Glide glide, @NonNull Lifecycle lifecycle, @NonNull RequestManagerTreeNode treeNode, @NonNull Context context) {
        this(glide, lifecycle, treeNode, new RequestTracker(), glide.getConnectivityMonitorFactory(), context);
    }

    RequestManager(Glide glide, Lifecycle lifecycle, RequestManagerTreeNode treeNode, RequestTracker requestTracker, ConnectivityMonitorFactory factory, Context context) {
        this.glide = glide;
        this.lifecycle = lifecycle;
        this.treeNode = treeNode;
        this.requestTracker = requestTracker;
        this.context = context;
        this.connectivityMonitor = factory.build(context.getApplicationContext(), new RequestManagerConnectivityListener(requestTracker));
        if (Util.isOnBackgroundThread()) {
            this.mainHandler.post(this.addSelfToLifecycle);
        } else {
            lifecycle.addListener(this);
        }
        lifecycle.addListener(this.connectivityMonitor);
        this.setRequestOptions(glide.getGlideContext().getDefaultRequestOptions());
        glide.registerRequestManager(this);
    }

    protected void setRequestOptions(@NonNull RequestOptions toSet) {
        this.requestOptions = toSet.clone().autoClone();
    }

    private void updateRequestOptions(@NonNull RequestOptions toUpdate) {
        this.requestOptions = this.requestOptions.apply(toUpdate);
    }

    @NonNull
    public RequestManager applyDefaultRequestOptions(@NonNull RequestOptions requestOptions) {
        this.updateRequestOptions(requestOptions);
        return this;
    }

    @NonNull
    public RequestManager setDefaultRequestOptions(@NonNull RequestOptions requestOptions) {
        this.setRequestOptions(requestOptions);
        return this;
    }

    public boolean isPaused() {
        Util.assertMainThread();
        return this.requestTracker.isPaused();
    }

    public void pauseRequests() {
        Util.assertMainThread();
        this.requestTracker.pauseRequests();
    }

    public void pauseAllRequests() {
        Util.assertMainThread();
        this.requestTracker.pauseAllRequests();
    }

    public void pauseRequestsRecursive() {
        Util.assertMainThread();
        this.pauseRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.pauseRequests();
        }
    }

    public void resumeRequests() {
        Util.assertMainThread();
        this.requestTracker.resumeRequests();
    }

    public void resumeRequestsRecursive() {
        Util.assertMainThread();
        this.resumeRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.resumeRequests();
        }
    }

    @Override
    public void onStart() {
        this.resumeRequests();
        this.targetTracker.onStart();
    }

    @Override
    public void onStop() {
        this.pauseRequests();
        this.targetTracker.onStop();
    }

    @Override
    public void onDestroy() {
        this.targetTracker.onDestroy();
        for (Target<?> target : this.targetTracker.getAll()) {
            this.clear(target);
        }
        this.targetTracker.clear();
        this.requestTracker.clearRequests();
        this.lifecycle.removeListener(this);
        this.lifecycle.removeListener(this.connectivityMonitor);
        this.mainHandler.removeCallbacks(this.addSelfToLifecycle);
        this.glide.unregisterRequestManager(this);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<Bitmap> asBitmap() {
        return this.as(Bitmap.class).apply(DECODE_TYPE_BITMAP);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<GifDrawable> asGif() {
        return this.as(GifDrawable.class).apply(DECODE_TYPE_GIF);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> asDrawable() {
        return this.as(Drawable.class);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Bitmap bitmap) {
        return this.asDrawable().load(bitmap);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Drawable drawable) {
        return this.asDrawable().load(drawable);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable String string) {
        return this.asDrawable().load(string);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Uri uri) {
        return this.asDrawable().load(uri);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable File file) {
        return this.asDrawable().load(file);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@RawRes @DrawableRes @Nullable Integer resourceId) {
        return this.asDrawable().load(resourceId);
    }

    @Override
    @Deprecated
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable URL url) {
        return this.asDrawable().load(url);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable byte[] model) {
        return this.asDrawable().load(model);
    }

    @Override
    @NonNull
    @CheckResult
    public RequestBuilder<Drawable> load(@Nullable Object model) {
        return this.asDrawable().load(model);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<File> downloadOnly() {
        return this.as(File.class).apply(DOWNLOAD_ONLY_OPTIONS);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<File> download(@Nullable Object model) {
        return this.downloadOnly().load(model);
    }

    @NonNull
    @CheckResult
    public RequestBuilder<File> asFile() {
        return this.as(File.class).apply(RequestOptions.skipMemoryCacheOf(true));
    }

    @NonNull
    @CheckResult
    public <ResourceType> RequestBuilder<ResourceType> as(@NonNull Class<ResourceType> resourceClass) {
        return new RequestBuilder<ResourceType>(this.glide, this, resourceClass, this.context);
    }

    public void clear(@NonNull View view) {
        this.clear(new ClearTarget(view));
    }

    public void clear(final @Nullable Target<?> target) {
        if (target == null) {
            return;
        }
        if (Util.isOnMainThread()) {
            this.untrackOrDelegate(target);
        } else {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    RequestManager.this.clear(target);
                }
            });
        }
    }

    private void untrackOrDelegate(@NonNull Target<?> target) {
        boolean isOwnedByUs = this.untrack(target);
        if (!isOwnedByUs && !this.glide.removeFromManagers(target) && target.getRequest() != null) {
            Request request = target.getRequest();
            target.setRequest(null);
            request.clear();
        }
    }

    boolean untrack(@NonNull Target<?> target) {
        Request request = target.getRequest();
        if (request == null) {
            return true;
        }
        if (this.requestTracker.clearRemoveAndRecycle(request)) {
            this.targetTracker.untrack(target);
            target.setRequest(null);
            return true;
        }
        return false;
    }

    void track(@NonNull Target<?> target, @NonNull Request request) {
        this.targetTracker.track(target);
        this.requestTracker.runRequest(request);
    }

    RequestOptions getDefaultRequestOptions() {
        return this.requestOptions;
    }

    @NonNull
    <T> TransitionOptions<?, T> getDefaultTransitionOptions(Class<T> transcodeClass) {
        return this.glide.getGlideContext().getDefaultTransitionOptions(transcodeClass);
    }

    public String toString() {
        return super.toString() + "{tracker=" + this.requestTracker + ", treeNode=" + this.treeNode + "}";
    }

    private static class ClearTarget
    extends ViewTarget<View, Object> {
        ClearTarget(@NonNull View view) {
            super(view);
        }

        @Override
        public void onResourceReady(@NonNull Object resource, @Nullable Transition<? super Object> transition) {
        }
    }

    private static class RequestManagerConnectivityListener
    implements ConnectivityMonitor.ConnectivityListener {
        private final RequestTracker requestTracker;

        RequestManagerConnectivityListener(@NonNull RequestTracker requestTracker) {
            this.requestTracker = requestTracker;
        }

        @Override
        public void onConnectivityChanged(boolean isConnected) {
            if (isConnected) {
                this.requestTracker.restartRequests();
            }
        }
    }
}

