/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.view.ContextThemeWrapper;

public final class DrawableDecoderCompat {
    private static volatile boolean shouldCallAppCompatResources = true;

    private DrawableDecoderCompat() {
    }

    public static Drawable getDrawable(Context ourContext, Context targetContext, @DrawableRes int id2) {
        return DrawableDecoderCompat.getDrawable(ourContext, targetContext, id2, null);
    }

    public static Drawable getDrawable(Context ourContext, @DrawableRes int id2, @Nullable Resources.Theme theme) {
        return DrawableDecoderCompat.getDrawable(ourContext, ourContext, id2, theme);
    }

    private static Drawable getDrawable(Context ourContext, Context targetContext, @DrawableRes int id2, @Nullable Resources.Theme theme) {
        try {
            if (shouldCallAppCompatResources) {
                return DrawableDecoderCompat.loadDrawableV7(targetContext, id2, theme);
            }
        }
        catch (NoClassDefFoundError error) {
            shouldCallAppCompatResources = false;
        }
        catch (IllegalStateException e) {
            if (ourContext.getPackageName().equals(targetContext.getPackageName())) {
                throw e;
            }
            return ContextCompat.getDrawable((Context)targetContext, (int)id2);
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return DrawableDecoderCompat.loadDrawableV4(targetContext, id2, theme != null ? theme : targetContext.getTheme());
    }

    private static Drawable loadDrawableV7(Context context, @DrawableRes int id2, @Nullable Resources.Theme theme) {
        Context resourceContext = theme != null ? new ContextThemeWrapper(context, theme) : context;
        return AppCompatResources.getDrawable((Context)resourceContext, (int)id2);
    }

    private static Drawable loadDrawableV4(Context context, @DrawableRes int id2, @Nullable Resources.Theme theme) {
        Resources resources = context.getResources();
        return ResourcesCompat.getDrawable((Resources)resources, (int)id2, (Resources.Theme)theme);
    }
}

