/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;

public class ThumbnailRequestCoordinator
implements RequestCoordinator,
Request {
    @Nullable
    private final RequestCoordinator parent;
    private Request full;
    private Request thumb;
    private boolean isRunning;

    @VisibleForTesting
    ThumbnailRequestCoordinator() {
        this(null);
    }

    public ThumbnailRequestCoordinator(@Nullable RequestCoordinator parent) {
        this.parent = parent;
    }

    public void setRequests(Request full, Request thumb) {
        this.full = full;
        this.thumb = thumb;
    }

    @Override
    public boolean canSetImage(Request request) {
        return this.parentCanSetImage() && (request.equals(this.full) || !this.full.isResourceSet());
    }

    private boolean parentCanSetImage() {
        return this.parent == null || this.parent.canSetImage(this);
    }

    @Override
    public boolean canNotifyStatusChanged(Request request) {
        return this.parentCanNotifyStatusChanged() && request.equals(this.full) && !this.isAnyResourceSet();
    }

    @Override
    public boolean canNotifyCleared(Request request) {
        return this.parentCanNotifyCleared() && request.equals(this.full);
    }

    private boolean parentCanNotifyCleared() {
        return this.parent == null || this.parent.canNotifyCleared(this);
    }

    private boolean parentCanNotifyStatusChanged() {
        return this.parent == null || this.parent.canNotifyStatusChanged(this);
    }

    @Override
    public boolean isAnyResourceSet() {
        return this.parentIsAnyResourceSet() || this.isResourceSet();
    }

    @Override
    public void onRequestSuccess(Request request) {
        if (request.equals(this.thumb)) {
            return;
        }
        if (this.parent != null) {
            this.parent.onRequestSuccess(this);
        }
        if (!this.thumb.isComplete()) {
            this.thumb.clear();
        }
    }

    @Override
    public void onRequestFailed(Request request) {
        if (!request.equals(this.full)) {
            return;
        }
        if (this.parent != null) {
            this.parent.onRequestFailed(this);
        }
    }

    private boolean parentIsAnyResourceSet() {
        return this.parent != null && this.parent.isAnyResourceSet();
    }

    @Override
    public void begin() {
        this.isRunning = true;
        if (!this.full.isComplete() && !this.thumb.isRunning()) {
            this.thumb.begin();
        }
        if (this.isRunning && !this.full.isRunning()) {
            this.full.begin();
        }
    }

    @Override
    public void pause() {
        this.isRunning = false;
        this.full.pause();
        this.thumb.pause();
    }

    @Override
    public void clear() {
        this.isRunning = false;
        this.thumb.clear();
        this.full.clear();
    }

    @Override
    public boolean isPaused() {
        return this.full.isPaused();
    }

    @Override
    public boolean isRunning() {
        return this.full.isRunning();
    }

    @Override
    public boolean isComplete() {
        return this.full.isComplete() || this.thumb.isComplete();
    }

    @Override
    public boolean isResourceSet() {
        return this.full.isResourceSet() || this.thumb.isResourceSet();
    }

    @Override
    public boolean isCancelled() {
        return this.full.isCancelled();
    }

    @Override
    public boolean isFailed() {
        return this.full.isFailed();
    }

    @Override
    public void recycle() {
        this.full.recycle();
        this.thumb.recycle();
    }

    @Override
    public boolean isEquivalentTo(Request o) {
        if (o instanceof ThumbnailRequestCoordinator) {
            ThumbnailRequestCoordinator that = (ThumbnailRequestCoordinator)o;
            return (this.full == null ? that.full == null : this.full.isEquivalentTo(that.full)) && (this.thumb == null ? that.thumb == null : this.thumb.isEquivalentTo(that.thumb));
        }
        return false;
    }
}

