/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data;

import android.support.annotation.NonNull;
import com.bumptech.glide.load.data.DataRewinder;
import com.bumptech.glide.util.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class DataRewinderRegistry {
    private final Map<Class<?>, DataRewinder.Factory<?>> rewinders = new HashMap();
    private static final DataRewinder.Factory<?> DEFAULT_FACTORY = new DataRewinder.Factory<Object>(){

        @Override
        @NonNull
        public DataRewinder<Object> build(@NonNull Object data) {
            return new DefaultRewinder(data);
        }

        @Override
        @NonNull
        public Class<Object> getDataClass() {
            throw new UnsupportedOperationException("Not implemented");
        }
    };

    public synchronized void register(@NonNull DataRewinder.Factory<?> factory) {
        this.rewinders.put(factory.getDataClass(), factory);
    }

    @NonNull
    public synchronized <T> DataRewinder<T> build(@NonNull T data) {
        Preconditions.checkNotNull(data);
        DataRewinder.Factory<?> result = this.rewinders.get(data.getClass());
        if (result == null) {
            for (DataRewinder.Factory<?> registeredFactory : this.rewinders.values()) {
                if (!registeredFactory.getDataClass().isAssignableFrom(data.getClass())) continue;
                result = registeredFactory;
                break;
            }
        }
        if (result == null) {
            result = DEFAULT_FACTORY;
        }
        return result.build(data);
    }

    private static final class DefaultRewinder
    implements DataRewinder<Object> {
        private final Object data;

        DefaultRewinder(@NonNull Object data) {
            this.data = data;
        }

        @Override
        @NonNull
        public Object rewindAndGet() {
            return this.data;
        }

        @Override
        public void cleanup() {
        }
    }
}

